/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.CustomCardMaker.components;

import LegendaryCardMaker.Icon;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;

public class JIconMenuItem
extends JCheckBoxMenuItem {
    public Icon icon;

    public JIconMenuItem(Icon i) {
        this.icon = i;
        super.setText(i.toString());
        if (i.getImagePath() != null) {
            super.setIcon(new ImageIcon(this.getIconMaxHeight(i, 20)));
        }
    }

    public BufferedImage getIconMaxHeight(Icon icon, int maxHeight) {
        ImageIcon ii = new ImageIcon(icon.getImagePath());
        double r = (double)maxHeight / (double)ii.getIconHeight();
        return this.resizeImage(ii, r);
    }

    public BufferedImage resizeImage(ImageIcon imageIcon, double scale) {
        int w = (int)((double)imageIcon.getIconWidth() * scale);
        int h = (int)((double)imageIcon.getIconHeight() * scale);
        int type = 2;
        if (w <= 0 || h <= 0) {
            return null;
        }
        BufferedImage image = new BufferedImage(w, h, type);
        Graphics g = image.getGraphics();
        g.drawImage(imageIcon.getImage(), 0, 0, w, h, 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
        g.dispose();
        return image;
    }
}

